/**
 * 定义所有验证器.
 */
define(["jquery",
        "abc.basic.request"], function($, request) {

	'use strict'; // 使用js语法严格模式(提高代码运行效率)

	var WebSocketUtil = function() {};
	WebSocketUtil.prototype = {
		/**
		 * 初始化Websocket.
		 * @param urlPath webscoket请求路径.
		 * @param option 配置参数.
		 * option = {'wsconn': ws, 'message': function(data){}, 'isOpen': false}
		 */
		createWebSocket : function(urlPath, option) {
			var that = this;
			if (window.location.protocol == 'http:') {  
				var url = 'ws://' + window.location.host + urlPath;  
			} else {  
				var url = 'wss://' + window.location.host + urlPath;  
			}
			if('WebSocket' in window) {
				var curWebSocket = new WebSocket(url);
				option['lastPing'] = new Date().getTime();
				option['lastPong'] = new Date().getTime();
			} else {
				request.notify("当前浏览器WebSocket不支持。");
			}
			curWebSocket.onopen = function() {
				console.log("websocket--onopen");
				that.heartCheck(option).reset().start();
				option["isOpen"] = true;
			};
			curWebSocket.onmessage = function(evt) {
				console.log("websocket--onmessage：" + evt.data);
				if (evt["data"].indexOf('pong:') == 0) {
					option['lastPong'] = new Date().getTime();
				} else {
					var callback = option.message;
					if (callback) {
						callback(JSON.parse(evt.data));
					}
				}
			};
			curWebSocket.onclose = function (evt) { 
				console.log('websocket--onclose: ' + evt.code + ' ' + evt.reason + ' ' + evt.wasClean);
				option["isOpen"] = false;
			};
			curWebSocket.onerror = function (evt) { 
				console.log('websocket--onerror');
			};
			option['urlPath'] = urlPath;
			option['wsconn'] = curWebSocket;
		},
		/**
		 * 重新连接.
		 */
		reconnect : function(option) {
			console.log("reconnect..." + option['urlPath']);
			this.createWebSocket(option['urlPath'], option);
		},
		
		/**
		 * 心跳检查.
		 */
		heartCheck : function(option) {
			var that = this;
			var _genSessionId = this["genSessionId"];
			return {
				timeoutObj: null,
				//serverTimeoutObj: null,
				reset: function(){
					clearTimeout(this.timeoutObj);
					//clearTimeout(this.serverTimeoutObj);
					return this;
				},
				isOffline : function(lastPing, lastPong) {
					var expired = 10 * 1000;
					var interval = Math.abs(lastPong - lastPing);
					return interval > expired;
				},
				start: function(){
					var self = this;
					var heartBeat = function() {
						try {
							self["timeoutObj"] = setTimeout(function(){
								var pingMessage = "ping:" + _genSessionId();
								if (option['wsconn'].readyState == 1) { // OPEN 状态.
									option['wsconn'].send(pingMessage);
									option['lastPing'] = new Date().getTime();
									console.log(pingMessage);
								}
								// 如果心跳间隔超时，重新连接.
								if (self.isOffline(option['lastPing'], option['lastPong'])) {
									clearTimeout(self["timeoutObj"]);
									option['wsconn'].close();
									that.reconnect(option);
									return;
								}
								heartBeat();
							}, 7*1000);
						} catch (e) {
							console.log("心跳失败..." + e);
							clearTimeout(self["timeoutObj"]);
						}
					};
					heartBeat();
				}
			};
		},
		
		/**
		 * 指定sessionId生成规则.
		 */
		setGenSessionId : function(callback) {
			this["genSessionId"] = callback;
		}
	};

	return new WebSocketUtil();
});