/**
 * base64加密、解密.<br>
 * 对应java端：Base64Coder
 * @author hewei <br>
 * @version 1.0.0 2018年11月1日<br>
 * @see 
 */
define(["jquery"], function ($) {
	var base64Util = {
		/**
		 * 加密数据参照.
		 */
		base64EncodeChars : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",
		
		/**
		 * 解密数据参照.
		 */
		base64DecodeChars : new Array(-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
									  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
									  -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57,
									  58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0,  1,  2,  3,  4,  5,  6,
									  7,  8,  9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
									  25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
									  37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1,
									  -1, -1),
			  
		/**
		 * 数据加密.
		 */  
		base64encode : function(str) {
			var out, i, len;
			var c1, c2, c3;
			len = str.length;
			i = 0;
			out = "";

			while (i < len) {
				c1 = str.charCodeAt(i++) & 0xff;

				if (i == len) {
					out += this.base64EncodeChars.charAt(c1 >> 2);
					out += this.base64EncodeChars.charAt((c1 & 0x3) << 4);
					out += "==";
					break
				}

				c2 = str.charCodeAt(i++);

				if (i == len) {
					out += this.base64EncodeChars.charAt(c1 >> 2);
					out += this.base64EncodeChars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xF0) >> 4));
					out += this.base64EncodeChars.charAt((c2 & 0xF) << 2);
					out += "=";
					break
				}

				c3 = str.charCodeAt(i++);
				out += this.base64EncodeChars.charAt(c1 >> 2);
				out += this.base64EncodeChars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xF0) >> 4));
				out += this.base64EncodeChars.charAt(((c2 & 0xF) << 2) | ((c3 & 0xC0) >> 6));
				out += this.base64EncodeChars.charAt(c3 & 0x3F)
			}
			// 自定义加密前需加上特定的符号
			if (out.length > 0) {
				out = "#@$" + out;
			}
			return out
		},
		
		/**
		 * 数据解密.
		 */
		base64decode : function(str) {
			// 只有str前面有特定表示加密的标志，才进行解密
			if (str.length > 3 && str.substr(0, 3) == "#@$") {
				str = str.substr(3);
				var c1, c2, c3, c4;
				var i, len, out;
				len = str.length;
				i = 0;
				out = "";
	
				while (i < len) {
					do {
						c1 = this.base64DecodeChars[str.charCodeAt(i++) & 0xff]
					} while (i < len && c1 == -1);
	
					if (c1 == -1) {
						break;
					}
					
	
					do {
						c2 = this.base64DecodeChars[str.charCodeAt(i++) & 0xff]
					} while (i < len && c2 == -1);
	
					if (c2 == -1) {
						break;
					}
	
					out += String.fromCharCode((c1 << 2) | ((c2 & 0x30) >> 4));
	
					do {
						c3 = str.charCodeAt(i++) & 0xff;
	
						if (c3 == 61) {
							return out;
						}
						c3 = this.base64DecodeChars[c3]
					} while (i < len && c3 == -1);
	
					if (c3 == -1) {
						break;
					}
	
					out += String.fromCharCode(((c2 & 0XF) << 4) | ((c3 & 0x3C) >> 2));
	
					do {
						c4 = str.charCodeAt(i++) & 0xff;
	
						if (c4 == 61) {
							return out;
						}
	
						c4 = this.base64DecodeChars[c4]
					} while (i < len && c4 == -1);
	
					if (c4 == -1) {
						break;
					}
	
					out += String.fromCharCode(((c3 & 0x03) << 6) | c4)
				}
				return out
			} else {
				return str;
			}
			
		}      
	};
	
	return base64Util;
});