/**存储事件（T_ABC_STORED_EVENT）**/
DROP TABLE IF EXISTS T_ABC_STORED_EVENT;
CREATE TABLE T_ABC_STORED_EVENT ( 
	GID bigint PRIMARY KEY COMMENT '主键',
	OWNERID VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	F_BIZSTATE INT default 0 not null COMMENT '业务状态',
	EVENT_BODY text NOT NULL COMMENT '事件体', 
	OCCURRED_ON datetime(3) NOT NULL COMMENT '发生时间',  
	TYPE_NAME varchar(200) NOT NULL COMMENT '事件类型'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;

/**方法调用跟踪（T_STD_CALL_METHOD_TRACE）**/
DROP TABLE IF EXISTS T_STD_CALL_METHOD_TRACE;
CREATE TABLE T_STD_CALL_METHOD_TRACE ( 
	GID BIGINT PRIMARY KEY COMMENT '主键',
	OWNERID VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	F_BIZSTATE INT default 0 not null COMMENT '业务状态',
	METHOD_NAME VARCHAR(200) NOT NULL COMMENT '方法名称', 
	METHOD_ARGUMENT LONGTEXT DEFAULT NULL COMMENT '调用参数', 
	RETURN_DATA LONGTEXT DEFAULT NULL COMMENT '返回结果', 
	BEGIN_TIME DATETIME(3) NOT NULL COMMENT '开始时间', 
	END_TIME  DATETIME(3) DEFAULT NULL COMMENT '结束时间', 
	COST INTEGER DEFAULT NULL COMMENT '执行耗时ms', 
	VALID_STATE INTEGER NOT NULL COMMENT '方法是否成功执行', 
	FAIL_CAUSE LONGTEXT DEFAULT NULL COMMENT '失败原因', 
	IP_ADDRESS VARCHAR(60) DEFAULT NULL COMMENT 'ip地址', 
	S_CREATOR VARCHAR(36) DEFAULT NULL COMMENT '操作人', 
	S_CREATE_TIME  DATETIME(3) NOT NULL COMMENT '创建时间'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;

/**转发跟踪表**/
DROP TABLE IF EXISTS T_STD_DISPATCH;
CREATE TABLE T_STD_DISPATCH(
	GID BIGINT PRIMARY KEY NOT NULL COMMENT '主键',
	OWNERID VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	F_BIZSTATE INT default 0 not null COMMENT '业务状态',
	SOURCE_TABLE VARCHAR(50) DEFAULT NULL COMMENT '来源表', 
	SOURCE_ID VARCHAR(500) DEFAULT NULL COMMENT '来源ID',
	SOURCE_DATA LONGTEXT NOT NULL COMMENT '来源数据', 
	TRY_COUNT INT DEFAULT '0' COMMENT '尝试次数', 
	MAX_COUNT INT DEFAULT '0' COMMENT '最大次数', 
	COMPLETED INT NOT NULL COMMENT '是否完成(0：否;1：是)', 
	DEST_NAME VARCHAR(100) NOT NULL COMMENT '目的地名称',
	TXID VARCHAR(100) DEFAULT NULL COMMENT '交易ID', 
	REMARK VARCHAR(1000) DEFAULT NULL COMMENT '备注', 
	S_CREATOR VARCHAR(36) NOT NULL COMMENT '创建者', 
	S_CREATE_TIME DATETIME NOT NULL COMMENT '创建时间',
	S_MODIFIER VARCHAR(36) NOT NULL COMMENT '修改者', 
	S_LAST_TIME DATETIME NOT NULL COMMENT '最后修改时间'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;

/**转发跟踪历史表**/
DROP TABLE IF EXISTS T_STD_DISPATCH_HISTORY;
CREATE TABLE T_STD_DISPATCH_HISTORY(
	GID BIGINT PRIMARY KEY NOT NULL COMMENT '主键',
	OWNERID VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	F_BIZSTATE INT default 0 not null COMMENT '业务状态',
	SOURCE_TABLE VARCHAR(50) DEFAULT NULL COMMENT '来源表', 
	SOURCE_ID VARCHAR(500) DEFAULT NULL COMMENT '来源ID',
	SOURCE_DATA LONGTEXT NOT NULL COMMENT '来源数据', 
	TRY_COUNT INT DEFAULT '0' COMMENT '尝试次数', 
	MAX_COUNT INT DEFAULT '0' COMMENT '最大次数', 
	COMPLETED INT NOT NULL COMMENT '是否完成(0：否;1：是)', 
	DEST_NAME VARCHAR(100) NOT NULL COMMENT '目的地名称', 
	TXID VARCHAR(100) DEFAULT NULL COMMENT '交易ID', 
	REMARK VARCHAR(1000) DEFAULT NULL COMMENT '备注', 
	S_CREATOR VARCHAR(36) NOT NULL COMMENT '创建者', 
	S_CREATE_TIME DATETIME NOT NULL COMMENT '创建时间',
	S_MODIFIER VARCHAR(36) NOT NULL COMMENT '修改者', 
	S_LAST_TIME DATETIME NOT NULL COMMENT '最后修改时间'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;

/**转发消费表**/
DROP TABLE IF EXISTS T_STD_CONSUME;
CREATE TABLE T_STD_CONSUME(
	GID BIGINT PRIMARY KEY NOT NULL COMMENT '主键',
	OWNERID VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	F_BIZSTATE INT default 0 not null COMMENT '业务状态',
	SOURCE_TABLE VARCHAR(50) DEFAULT NULL COMMENT '来源表', 
	SOURCE_ID VARCHAR(500) DEFAULT NULL COMMENT '来源ID',
	SOURCE_DATA LONGTEXT NOT NULL COMMENT '来源数据', 
	TRY_COUNT INT DEFAULT '0' COMMENT '尝试次数', 
	MAX_COUNT INT DEFAULT '0' COMMENT '最大次数', 
	COMPLETED INT NOT NULL COMMENT '是否完成(0：否;1：是)', 
	DEST_NAME VARCHAR(100) NOT NULL COMMENT '目的地名称',
	TXID VARCHAR(100) DEFAULT NULL COMMENT '交易ID', 
	REMARK VARCHAR(1000) DEFAULT NULL COMMENT '备注', 
	S_CREATOR VARCHAR(36) NOT NULL COMMENT '创建者', 
	S_CREATE_TIME DATETIME NOT NULL COMMENT '创建时间',
	S_MODIFIER VARCHAR(36) NOT NULL COMMENT '修改者', 
	S_LAST_TIME DATETIME NOT NULL COMMENT '最后修改时间'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;

/**转发消费历史表**/
DROP TABLE IF EXISTS T_STD_CONSUME_HISTORY;
CREATE TABLE T_STD_CONSUME_HISTORY(
	GID BIGINT PRIMARY KEY NOT NULL COMMENT '主键',
	OWNERID VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	F_BIZSTATE INT default 0 not null COMMENT '业务状态',
	SOURCE_TABLE VARCHAR(50) DEFAULT NULL COMMENT '来源表', 
	SOURCE_ID VARCHAR(500) DEFAULT NULL COMMENT '来源ID',
	SOURCE_DATA LONGTEXT NOT NULL COMMENT '来源数据', 
	TRY_COUNT INT DEFAULT '0' COMMENT '尝试次数', 
	MAX_COUNT INT DEFAULT '0' COMMENT '最大次数', 
	COMPLETED INT NOT NULL COMMENT '是否完成(0：否;1：是)', 
	DEST_NAME VARCHAR(100) NOT NULL COMMENT '目的地名称', 
	TXID VARCHAR(100) DEFAULT NULL COMMENT '交易ID', 
	REMARK VARCHAR(1000) DEFAULT NULL COMMENT '备注', 
	S_CREATOR VARCHAR(36) NOT NULL COMMENT '创建者', 
	S_CREATE_TIME DATETIME NOT NULL COMMENT '创建时间',
	S_MODIFIER VARCHAR(36) NOT NULL COMMENT '修改者', 
	S_LAST_TIME DATETIME NOT NULL COMMENT '最后修改时间'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;

/**业务序号表（T_STD_SEQUENCE_NUMBER）**/
DROP TABLE IF EXISTS T_STD_SEQUENCE_NUMBER;
CREATE TABLE T_STD_SEQUENCE_NUMBER ( 
	`GID` BIGINT PRIMARY KEY COMMENT '主键',
	`OWNERID` VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	`F_BIZSTATE` TINYINT NOT NULL DEFAULT '0',
	`S_CREATE_TIME`  DATETIME(3) NOT NULL COMMENT '创建时间',
	`S_CREATOR` VARCHAR(36) DEFAULT NULL COMMENT '操作人', 
	`S_LAST_TIME` DATETIME(3) DEFAULT NULL COMMENT '最后更新时间',
	`S_MODIFIER` VARCHAR(36) DEFAULT NULL COMMENT '最后更新人.',
	`S_VERSION`  INT default 0 COMMENT '版本号',
	`TYPE_NAME`  VARCHAR(30) COMMENT '类型名称',
	`SEQ_NUMBER`  INT COMMENT '序号值'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;

/* 系统参数配置 */
DROP TABLE IF EXISTS T_STD_SYSTEMCONFIG;
CREATE TABLE T_STD_SYSTEMCONFIG (
	GID BIGINT PRIMARY KEY NOT NULL COMMENT '主键',
	OWNERID VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	F_BIZSTATE INT default 0 not null COMMENT '业务状态',
	PROPERTY_NAME VARCHAR(100) NOT NULL COMMENT '属性名称',
	PROPERTY_VALUE VARCHAR(100) NOT NULL COMMENT '属性值',
	REMARK VARCHAR(200) NOT NULL COMMENT '备注'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;

/*附件临时表（T_STD_ATTACT_TEMP）*/
DROP TABLE IF EXISTS T_STD_ATTACT_TEMP;
CREATE TABLE T_STD_ATTACT_TEMP ( 
	`GID` BIGINT PRIMARY KEY COMMENT '主键',
	`OWNERID` VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	`F_BIZSTATE` TINYINT NOT NULL DEFAULT '0',
	`S_CREATE_TIME`  DATETIME(3) NOT NULL COMMENT '创建时间',
	`S_CREATOR` VARCHAR(36) DEFAULT NULL COMMENT '操作人', 
	`S_LAST_TIME` DATETIME(3) DEFAULT NULL COMMENT '最后更新时间',
	`S_MODIFIER` VARCHAR(36) DEFAULT NULL COMMENT '最后更新人.',
	`USER_GID`  VARCHAR(36) NOT NULL COMMENT '用户gid',
	`ATTACH_GID`  VARCHAR(36) NOT NULL COMMENT '附件gid',
	`RELATION_TABLE` VARCHAR(50) NOT NULL COMMENT '关联实体表',
	`VALID_STATE` INT DEFAULT NULL COMMENT '有效状态'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;


/*附件跟踪表（T_STD_ATTACT_TRACE）*/
DROP TABLE IF EXISTS T_STD_ATTACT_TRACE;
CREATE TABLE T_STD_ATTACT_TRACE ( 
	`GID` BIGINT PRIMARY KEY COMMENT '主键',
	`OWNERID` VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	`F_BIZSTATE` TINYINT NOT NULL DEFAULT '0',
	`S_CREATE_TIME`  DATETIME(3) NOT NULL COMMENT '创建时间',
	`S_CREATOR` VARCHAR(36) DEFAULT NULL COMMENT '操作人', 
	`S_LAST_TIME` DATETIME(3) DEFAULT NULL COMMENT '最后更新时间',
	`S_MODIFIER` VARCHAR(36) DEFAULT NULL COMMENT '最后更新人.',
	`TENANT_GID`  VARCHAR(36) NOT NULL COMMENT '租户gid',
	`ORG_GID`  VARCHAR(36) NOT NULL COMMENT '组织gid',
	`USER_GID`  VARCHAR(36) NOT NULL COMMENT '用户gid',
	`ATTACH_GID`  VARCHAR(36) NOT NULL COMMENT '附件gid',
	`RELATION_TABLE`  VARCHAR(50) NOT NULL COMMENT '关联实体表',
	`RELATION_GID`  BIGINT NOT NULL COMMENT '关联gid'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;
CREATE UNIQUE INDEX UNI_ATTACH_GID ON T_STD_ATTACT_TRACE(ATTACH_GID);

/*附件单据关联表（T_STD_ATTACT_BILL_RELATION）*/
DROP TABLE IF EXISTS T_STD_ATTACT_BILL_RELATION;
CREATE TABLE  T_STD_ATTACT_BILL_RELATION(
	GID                     BIGINT PRIMARY KEY NOT NULL COMMENT '主键',
	BILL_GID                BIGINT NOT NULL COMMENT '单据GID',
	RESOURCE_GID            VARCHAR(36) NOT NULL COMMENT '资源GID',
	ATTACH_TYPE             TINYINT DEFAULT NULL COMMENT '附件类型',
	REMARK                  VARCHAR(200) DEFAULT NULL COMMENT '备注',
	OWNERID                 VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	F_BIZSTATE              TINYINT DEFAULT 0 NOT NULL,
	S_CREATE_TIME           DATETIME(3) NOT NULL COMMENT '创建时间',
	S_CREATOR               VARCHAR(36) COMMENT '创建者',
	S_LAST_TIME             DATETIME(3) NOT NULL COMMENT '最后修改时间',
	S_MODIFIER              VARCHAR(36) COMMENT '修改者'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;
CREATE INDEX IDX_ATTACH_BILL_GID ON T_STD_ATTACT_BILL_RELATION(BILL_GID);

/**定时任务跟踪表**/
DROP TABLE IF EXISTS T_STD_TIMED_TASK_TRACE;
CREATE TABLE T_STD_TIMED_TASK_TRACE(
	GID BIGINT PRIMARY KEY NOT NULL COMMENT '主键',
	TASK_NAME VARCHAR(100) DEFAULT NULL COMMENT '任务名称', 
	TASK_ARGUMENT VARCHAR(1000) DEFAULT NULL COMMENT '任务参数',
	COMPLETED INT NOT NULL COMMENT '是否完成(0：否;1：是)',
	DEAD_TIME DATETIME NOT NULL COMMENT '截止时间', 
	S_VERSION INT default 0 COMMENT '版本号',
	OWNERID VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	F_BIZSTATE TINYINT NOT NULL DEFAULT '0',
	S_CREATOR VARCHAR(36) NOT NULL COMMENT '创建者', 
	S_CREATE_TIME DATETIME NOT NULL COMMENT '创建时间',
	S_MODIFIER VARCHAR(36) NOT NULL COMMENT '修改者', 
	S_LAST_TIME DATETIME NOT NULL COMMENT '最后修改时间'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;

/**定时任务历史表**/
DROP TABLE IF EXISTS T_STD_TIMED_TASK_HISTORY;
CREATE TABLE T_STD_TIMED_TASK_HISTORY(
	GID BIGINT PRIMARY KEY NOT NULL COMMENT '主键',
	TASK_NAME VARCHAR(100) DEFAULT NULL COMMENT '任务名称', 
	TASK_ARGUMENT VARCHAR(1000) DEFAULT NULL COMMENT '任务参数',
	COMPLETED INT NOT NULL COMMENT '是否完成(0：否;1：是)', 
	DEAD_TIME DATETIME NOT NULL COMMENT '截止时间', 
	S_VERSION INT default 0 COMMENT '版本号',
	OWNERID VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	F_BIZSTATE TINYINT NOT NULL DEFAULT '0',
	S_CREATOR VARCHAR(36) NOT NULL COMMENT '创建者', 
	S_CREATE_TIME DATETIME NOT NULL COMMENT '创建时间',
	S_MODIFIER VARCHAR(36) NOT NULL COMMENT '修改者', 
	S_LAST_TIME DATETIME NOT NULL COMMENT '最后修改时间'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;

/**印章表**/
DROP TABLE IF EXISTS T_STD_SEAL;
CREATE TABLE T_STD_SEAL (
	GID 			BIGINT PRIMARY KEY NOT NULL COMMENT '主键',
	S_VERSION 		INT DEFAULT 0 COMMENT '版本号',
	OWNERID 		VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	F_BIZSTATE 		TINYINT NOT NULL DEFAULT '0',
	S_CREATOR 		VARCHAR(36) NOT NULL COMMENT '创建者', 
	S_CREATE_TIME 	DATETIME NOT NULL COMMENT '创建时间',
	S_MODIFIER 		VARCHAR(36) NOT NULL COMMENT '修改者', 
	S_LAST_TIME 	DATETIME NOT NULL COMMENT '最后修改时间',
	DPI           	BIGINT COMMENT '印章图片的dpi',
	SERIAL_NUMBER 	VARCHAR(64) COMMENT '证书序列号',
	RES_ID        	VARCHAR(64) COMMENT '印章图片对应的资源id',
	SEAL_NAME     	VARCHAR(100) COMMENT '印章名称',
	SUBJECT_DN    	VARCHAR(200) COMMENT '证书主题dn',
	CERT_VALID    	DATE COMMENT '证书有效期'
) COMMENT '印章表' ENGINE=INNODB DEFAULT CHARSET=utf8mb4;

/**REST调用跟踪（T_STD_REST_TRACE）**/
DROP TABLE IF EXISTS T_STD_REST_TRACE;
CREATE TABLE T_STD_REST_TRACE ( 
	GID BIGINT PRIMARY KEY COMMENT '主键',
	OWNERID VARCHAR(36) DEFAULT NULL COMMENT '拥有者ID',
	F_BIZSTATE INT default 0 not null COMMENT '业务状态',
	REQUEST_URL VARCHAR(2000) NOT NULL COMMENT '请求url', 
	REQUEST_METHOD VARCHAR(20) NOT NULL COMMENT '请求方法', 
	REQUEST_HEADER VARCHAR(2000) DEFAULT NULL COMMENT '请求头', 
	REQUEST_BODY LONGTEXT DEFAULT NULL COMMENT '请求体',
	RESPONSE_STATUS VARCHAR(50) DEFAULT NULL COMMENT '响应状态', 
	RESPONSE_HEADER VARCHAR(2000) DEFAULT NULL COMMENT '响应头', 
	RESPONSE_DATA LONGTEXT DEFAULT NULL COMMENT '响应数据', 
	BEGIN_TIME DATETIME(3) NOT NULL COMMENT '开始时间', 
	END_TIME DATETIME(3) DEFAULT NULL COMMENT '结束时间', 
	COST INTEGER DEFAULT NULL COMMENT '执行耗时ms', 
	VALID_STATE INTEGER NOT NULL COMMENT '方法是否成功执行', 
	IP_ADDRESS VARCHAR(60) DEFAULT NULL COMMENT 'ip地址', 
	S_CREATOR VARCHAR(36) DEFAULT NULL COMMENT '操作人', 
	S_CREATE_TIME  DATETIME(3) NOT NULL COMMENT '创建时间'
)ENGINE=INNODB DEFAULT CHARSET=utf8mb4;
COMMIT;