/*
 * Decompiled with CFR 0.152.
 */
package org.djdom4j.xpath;

import java.io.Serializable;
import org.djdom4j.Document;
import org.djdom4j.Element;
import org.djdom4j.Namespace;
import org.djdom4j.Node;
import org.jaxen.NamespaceContext;

public class DefaultNamespaceContext
implements NamespaceContext,
Serializable {
    private final Element element;

    public DefaultNamespaceContext(Element element) {
        this.element = element;
    }

    public static DefaultNamespaceContext create(Object node) {
        Element element = null;
        if (node instanceof Element) {
            element = (Element)node;
        } else if (node instanceof Document) {
            Document doc = (Document)node;
            element = doc.getRootElement();
        } else if (node instanceof Node) {
            element = ((Node)node).getParent();
        }
        if (element != null) {
            return new DefaultNamespaceContext(element);
        }
        return null;
    }

    @Override
    public String translateNamespacePrefixToUri(String prefix) {
        Namespace ns;
        if (prefix != null && prefix.length() > 0 && (ns = this.element.getNamespaceForPrefix(prefix)) != null) {
            return ns.getURI();
        }
        return null;
    }
}

