/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1InputStream;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Set;
import cn.org.bjca.gaia.asn1.DERSet;
import cn.org.bjca.gaia.asn1.pkcs.ContentInfo;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.SignedData;
import cn.org.bjca.gaia.asn1.x500.X500Name;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.assemb.base.GaiaProvider;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.util.ASN1Util;
import cn.org.bjca.gaia.assemb.util.Base64Util;
import cn.org.bjca.gaia.assemb.util.CertificateUtil;
import cn.org.bjca.gaia.util.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;

public class P7bUtil {
    private GaiaProvider provider = null;

    public P7bUtil(GaiaProvider provider) {
        this.provider = provider;
    }

    public static ArrayList getCertChainByP7(byte[] in) throws PkiException {
        ArrayList<byte[]> certList = new ArrayList<byte[]>();
        Certificate[] certChain = P7bUtil.getCertChain(in);
        if (certChain == null) {
            throw new PkiException("11011001", "\u83b7\u53d6\u8bc1\u4e66\u94fe\u5931\u8d25 certChain is null");
        }
        int chainLen = certChain.length;
        try {
            for (int i = 0; i < chainLen; ++i) {
                certList.add(certChain[i].getEncoded());
            }
        }
        catch (Exception e) {
            throw new PkiException("11011001", "\u83b7\u53d6\u8bc1\u4e66\u94fe\u5931\u8d25 ", e);
        }
        return certList;
    }

    public static Certificate[] getCertChain(byte[] in) throws PkiException {
        ASN1Object asn1Object;
        ContentInfo content;
        Certificate[] certs = null;
        if (Base64Util.isBase64Encode(in)) {
            in = Base64Util.convertBase64(in);
            in = Base64.decode(in);
        }
        if (!(content = ContentInfo.getInstance(asn1Object = ASN1Util.checkAndGetASN1Object(in))).getContentType().equals(PKCSObjectIdentifiers.signedData)) {
            throw new PkiException("11011001", "\u83b7\u53d6\u8bc1\u4e66\u94fe\u5931\u8d25 Not a valid PKCS#7 signed-data object - wrong header " + content.getContentType().getId());
        }
        SignedData data = SignedData.getInstance(content.getContent());
        ASN1Set certSet = data.getCertificates();
        Certificate[] resultSortCerts = null;
        if (certSet != null) {
            certs = new Certificate[certSet.size()];
            Enumeration ec = ASN1Set.getInstance(data.getCertificates()).getObjects();
            int i = 0;
            try {
                while (ec.hasMoreElements()) {
                    certs[i] = Certificate.getInstance(ec.nextElement());
                    ++i;
                }
                resultSortCerts = P7bUtil.sortCertificates(certs);
            }
            catch (Exception e) {
                throw new PkiException("11011001", "\u83b7\u53d6\u8bc1\u4e66\u94fe\u5931\u8d25 ", e);
            }
        }
        return resultSortCerts;
    }

    public static Certificate[] sortCertificates(Certificate[] certs) throws PkiException {
        int certLen = certs.length;
        Certificate[] certsSort = new Certificate[certLen];
        Certificate rootCert = null;
        for (int i = 0; i < certLen; ++i) {
            X500Name issuerDN;
            Certificate cert = certs[i];
            X500Name subjectDN = cert.getSubject();
            if (!subjectDN.equals(issuerDN = cert.getIssuer())) continue;
            rootCert = cert;
            certs[i] = null;
            break;
        }
        certsSort[certLen - 1] = rootCert;
        Certificate markCert = rootCert;
        if (markCert == null) {
            throw new PkiException("11011001", "\u83b7\u53d6\u8bc1\u4e66\u94fe\u5931\u8d25 rootCert is null");
        }
        block1: for (int j = 0; j < certLen - 1; ++j) {
            X500Name markSubjectDN = markCert.getSubject();
            for (int h = 0; h < certLen; ++h) {
                Certificate tempCert;
                X500Name tempIssuerDN;
                if (certs[h] == null || !markSubjectDN.equals(tempIssuerDN = (tempCert = certs[h]).getIssuer())) continue;
                markCert = tempCert;
                certsSort[certLen - j - 2] = tempCert;
                continue block1;
            }
        }
        return certsSort;
    }

    public boolean validateCertChain(Certificate[] certChain) throws PkiException {
        int len = certChain.length;
        if (len < 2) {
            return true;
        }
        for (int i = 1; i < len; ++i) {
            boolean isSuccess = this.validateCertSignature(certChain[i], certChain[i - 1]);
            if (isSuccess) continue;
            return false;
        }
        return true;
    }

    private boolean validateCertSignature(Certificate fatherCert, Certificate childCert) throws PkiException {
        boolean isSuccess = false;
        CertificateUtil certificateUtil = new CertificateUtil(this.provider);
        try {
            isSuccess = certificateUtil.validateCert(childCert.getEncoded(), fatherCert.getEncoded());
        }
        catch (Exception e) {
            throw new PkiException("11011002", "\u9a8c\u8bc1\u8bc1\u4e66\u94fe\u5931\u8d25 ", e);
        }
        return isSuccess;
    }

    public static String buildCertChainForDerEncode(String[] certs, boolean isSort) throws PkiException {
        try {
            ASN1EncodableVector asn1EncodableVector = new ASN1EncodableVector();
            X500Name rootSubject = null;
            Certificate certificate = null;
            for (String cert : certs) {
                byte[] decode = Base64.decode(cert);
                certificate = Certificate.getInstance(decode);
                if (certificate == null) {
                    throw new PkiException("11011005", "\u6784\u9020\u8bc1\u4e66\u94fe,\u89e3\u6790\u8bc1\u4e66\u5931\u8d25");
                }
                if (isSort && certificate.getIssuer().equals(certificate.getSubject())) {
                    rootSubject = certificate.getSubject();
                    asn1EncodableVector.add(certificate);
                }
                if (isSort) continue;
                asn1EncodableVector.add(certificate);
            }
            if (isSort) {
                if (rootSubject == null) {
                    throw new PkiException("11011003", "\u6784\u9020\u8bc1\u4e66\u94fe,\u672a\u53d1\u73b0\u6839\u8bc1\u4e66");
                }
                asn1EncodableVector = P7bUtil.sortCert(certs, rootSubject, asn1EncodableVector);
                asn1EncodableVector.reverse();
                if (asn1EncodableVector.size() != certs.length) {
                    throw new PkiException("11011004", "\u6784\u9020\u8bc1\u4e66\u94fe,\u4f20\u5165\u8bc1\u4e66\u4e0d\u80fd\u6210\u94fe");
                }
            }
            DERSet certSet = new DERSet(asn1EncodableVector, false);
            ContentInfo ci = new ContentInfo(PKCSObjectIdentifiers.data, null);
            DERSet asn1Encodables = new DERSet(false);
            DERSet asn1Encodables1 = new DERSet(false);
            SignedData signedData = new SignedData(new ASN1Integer(1L), asn1Encodables, ci, certSet, null, asn1Encodables1);
            ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
            return Base64.toBase64String(contentInfo.getEncoded("DER"));
        }
        catch (PkiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PkiException("11011006", "\u6784\u9020\u8bc1\u4e66\u94fe,\u5931\u8d25", e);
        }
    }

    private static ASN1EncodableVector sortCert(String[] certs, X500Name subject, ASN1EncodableVector asn1EncodableVector) {
        for (String cert : certs) {
            Certificate certificate = Certificate.getInstance(Base64.decode(cert));
            if (certificate.getIssuer().equals(certificate.getSubject()) || !certificate.getIssuer().equals(subject)) continue;
            asn1EncodableVector.add(certificate);
            asn1EncodableVector = P7bUtil.sortCert(certs, certificate.getSubject(), asn1EncodableVector);
        }
        return asn1EncodableVector;
    }

    private static ASN1Primitive buildDer(byte[] input) throws IOException {
        ByteArrayInputStream bai = new ByteArrayInputStream(input);
        ASN1InputStream ains = new ASN1InputStream(bai);
        return ains.readObject();
    }
}

