/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cms;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.cms.CMSRuntimeException;
import cn.org.bjca.gaia.cms.CMSTypedStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PKCS7TypedStream
extends CMSTypedStream {
    private final ASN1Encodable content;

    public PKCS7TypedStream(ASN1ObjectIdentifier oid, ASN1Encodable encodable) throws IOException {
        super(oid);
        this.content = encodable;
    }

    public ASN1Encodable getContent() {
        return this.content;
    }

    @Override
    public InputStream getContentStream() {
        try {
            return this.getContentStream(this.content);
        }
        catch (IOException e) {
            throw new CMSRuntimeException("unable to convert content to stream: " + e.getMessage(), e);
        }
    }

    @Override
    public void drain() throws IOException {
        this.getContentStream(this.content);
    }

    private InputStream getContentStream(ASN1Encodable encodable) throws IOException {
        byte[] encoded = encodable.toASN1Primitive().getEncoded("DER");
        int index = 1;
        while ((encoded[index] & 0xFF) > 127) {
            ++index;
        }
        return new ByteArrayInputStream(encoded, ++index, encoded.length - index);
    }
}

