/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.jcajce.provider.mceliece;

import cn.org.bjca.gaia.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.gaia.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import cn.org.bjca.gaia.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import cn.org.bjca.gaia.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class McElieceKeysToParams {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof BCMcEliecePublicKey) {
            BCMcEliecePublicKey k = (BCMcEliecePublicKey)key;
            return k.getKeyParams();
        }
        throw new InvalidKeyException("can't identify McEliece public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof BCMcEliecePrivateKey) {
            BCMcEliecePrivateKey k = (BCMcEliecePrivateKey)key;
            return new McEliecePrivateKeyParameters(k.getN(), k.getK(), k.getField(), k.getGoppaPoly(), k.getP1(), k.getP2(), k.getSInv());
        }
        throw new InvalidKeyException("can't identify McEliece private key.");
    }
}

