/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampResponseGenerator;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenGenerator;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class MyTest {
    public static BigInteger serialNumber = BigInteger.ONE;

    private static BigInteger allocateSerialNumber() {
        BigInteger _tmp = serialNumber;
        serialNumber = serialNumber.add(BigInteger.ONE);
        return _tmp;
    }

    private static SubjectKeyIdentifier createSubjectKeyId(PublicKey _pubKey) throws IOException {
        ByteArrayInputStream _bais = new ByteArrayInputStream(_pubKey.getEncoded());
        SubjectPublicKeyInfo _info = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(_bais).readObject());
        return new SubjectKeyIdentifier(_info);
    }

    private static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey _pubKey) throws IOException {
        ByteArrayInputStream _bais = new ByteArrayInputStream(_pubKey.getEncoded());
        SubjectPublicKeyInfo _info = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(_bais).readObject());
        return new AuthorityKeyIdentifier(_info);
    }

    public static X509Certificate makeCertificate(KeyPair _subKP, String _subDN, KeyPair _issKP, String _issDN, boolean _ca) throws GeneralSecurityException, IOException {
        PublicKey _subPub = _subKP.getPublic();
        PrivateKey _issPriv = _issKP.getPrivate();
        PublicKey _issPub = _issKP.getPublic();
        X509V3CertificateGenerator _v3CertGen = new X509V3CertificateGenerator();
        _v3CertGen.reset();
        _v3CertGen.setSerialNumber(MyTest.allocateSerialNumber());
        _v3CertGen.setIssuerDN(new X509Name(_issDN));
        _v3CertGen.setNotBefore(new Date(System.currentTimeMillis()));
        _v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 8640000000L));
        _v3CertGen.setSubjectDN(new X509Name(_subDN));
        _v3CertGen.setPublicKey(_subPub);
        _v3CertGen.setSignatureAlgorithm("SHA1WITHRSAENCRYPTION");
        _v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.SubjectKeyIdentifier, false, MyTest.createSubjectKeyId(_subPub));
        _v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.AuthorityKeyIdentifier, false, MyTest.createAuthorityKeyId(_issPub));
        if (_ca) {
            _v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.BasicConstraints, false, new BasicConstraints(_ca));
        } else {
            _v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.ExtendedKeyUsage, true, new ExtendedKeyUsage(new DERSequence(KeyPurposeId.id_kp_timeStamping)));
        }
        X509Certificate _cert = _v3CertGen.generate(_issPriv);
        _cert.checkValidity(new Date());
        _cert.verify(_issPub);
        return _cert;
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        SecureRandom rand = new SecureRandom();
        KeyPairGenerator eckpg = KeyPairGenerator.getInstance("RSA", "BC");
        eckpg.initialize(1024, rand);
        String signDN = "CN=TSRoot,O=BJCA, C=CN";
        KeyPair signKP = eckpg.generateKeyPair();
        X509Certificate signCert = MyTest.makeCertificate(signKP, signDN, signKP, signDN, true);
        System.out.println("cert:" + new String(Base64.encode(signCert.getEncoded())));
        String origDN = "CN=TSTest,O=BJCA, C=CN";
        KeyPair origKP = eckpg.generateKeyPair();
        X509Certificate origCert = MyTest.makeCertificate(origKP, origDN, signKP, signDN, false);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(origCert);
        certList.add(signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build("SHA1withRSA", origKP.getPrivate(), origCert), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        reqGen.setCertReq(true);
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        byte[] requestByte = request.getEncoded();
        System.out.println("reqeust == " + new String(Base64.encode(requestByte)));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        String hexStr = new String(Hex.encode(tsResp.getEncoded()));
        System.out.println(hexStr);
        System.out.println(new String(Base64.encode(Hex.decode(hexStr))));
        System.out.println(new String(Base64.encode(tsResp.getEncoded())));
        System.out.println("-----------------");
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        System.out.println(new String(Base64.encode(tsResp.getTimeStampToken().getEncoded())));
        ByteArrayInputStream bai = new ByteArrayInputStream(tsResp.getEncoded());
        ASN1InputStream ains = new ASN1InputStream(bai);
        ASN1Sequence subs = (ASN1Sequence)ains.readObject();
        System.out.println("***********************************");
        byte[] seq = subs.getObjectAt(1).toASN1Primitive().getEncoded();
        System.out.println(new String(Base64.encode(seq)));
        System.out.println(new String(Hex.encode(seq)));
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(origCert));
        AttributeTable table = tsToken.getSignedAttributes();
    }
}

