/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;
import xjyb.org.bjca.crypto.AsymmetricBlockCipher;
import xjyb.org.bjca.crypto.CryptoException;
import xjyb.org.bjca.crypto.Digest;
import xjyb.org.bjca.crypto.digests.SHA1Digest;
import xjyb.org.bjca.crypto.digests.SHA224Digest;
import xjyb.org.bjca.crypto.digests.SHA256Digest;
import xjyb.org.bjca.crypto.digests.SHA384Digest;
import xjyb.org.bjca.crypto.digests.SHA512Digest;
import xjyb.org.bjca.crypto.engines.RSABlindedEngine;
import xjyb.org.bjca.crypto.params.ParametersWithRandom;
import xjyb.org.bjca.crypto.signers.PSSSigner;
import xjyb.org.bjca.jce.provider.RSAUtil;

public class JDKPSSSigner
extends Signature {
    private AsymmetricBlockCipher signer;
    private Digest digest;
    private int saltLength;
    private AlgorithmParameters engineParams;
    private PSSSigner pss;

    protected JDKPSSSigner(String name, AsymmetricBlockCipher signer, Digest digest) {
        super(name);
        this.signer = signer;
        this.digest = digest;
        this.saltLength = digest != null ? digest.getDigestSize() : 20;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPublicKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.digest, this.saltLength);
        this.pss.init(false, RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey));
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.digest, this.saltLength);
        this.pss.init(true, new ParametersWithRandom(RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey), random));
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.digest, this.saltLength);
        this.pss.init(true, RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey));
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.pss.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.pss.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            return this.pss.generateSignature();
        }
        catch (CryptoException e) {
            throw new SignatureException(e.getMessage());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        return this.pss.verifySignature(sigBytes);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidParameterException {
        if (!(params instanceof PSSParameterSpec)) {
            throw new InvalidParameterException("Only PSSParameterSpec supported");
        }
        this.saltLength = ((PSSParameterSpec)params).getSaltLength();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("PSS", "BC");
                this.engineParams.init(new PSSParameterSpec(this.saltLength));
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    public static class SHA512withRSA
    extends JDKPSSSigner {
        public SHA512withRSA() {
            super("SHA512withRSAandMGF1", new RSABlindedEngine(), new SHA512Digest());
        }
    }

    public static class SHA384withRSA
    extends JDKPSSSigner {
        public SHA384withRSA() {
            super("SHA384withRSAandMGF1", new RSABlindedEngine(), new SHA384Digest());
        }
    }

    public static class SHA256withRSA
    extends JDKPSSSigner {
        public SHA256withRSA() {
            super("SHA256withRSAandMGF1", new RSABlindedEngine(), new SHA256Digest());
        }
    }

    public static class SHA224withRSA
    extends JDKPSSSigner {
        public SHA224withRSA() {
            super("SHA224withRSAandMGF1", new RSABlindedEngine(), new SHA224Digest());
        }
    }

    public static class SHA1withRSA
    extends JDKPSSSigner {
        public SHA1withRSA() {
            super("SHA1withRSAandMGF1", new RSABlindedEngine(), new SHA1Digest());
        }
    }

    public static class PSSwithRSA
    extends JDKPSSSigner {
        public PSSwithRSA() {
            super("SHA1withRSAandMGF1", new RSABlindedEngine(), null);
        }
    }
}

